<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('academic_years', function(Blueprint $table) {
			$table->foreign('education_system_id')->references('id')->on('education_systems')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subjects', function(Blueprint $table) {
			$table->foreign('academic_year_id')->references('id')->on('academic_years')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('education_systems', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teacher_subject', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teacher_subject', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lessons_times', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lessons_times', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('students', function(Blueprint $table) {
			$table->foreign('academic_year_id')->references('id')->on('academic_years')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_subject', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_subject', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_lesson', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_lesson', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('sub_category_id')->references('id')->on('sub_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_progress', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('student_progress', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parents', function(Blueprint $table) {
			$table->foreign('education_system_id')->references('id')->on('education_systems')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_parent', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_parent', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('parents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('presence_absence', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('presence_absence', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->foreign('blog_category_id')->references('id')->on('blog_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('views', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_favourites', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('academic_years', function(Blueprint $table) {
			$table->dropForeign('academic_years_education_system_id_foreign');
		});
		Schema::table('subjects', function(Blueprint $table) {
			$table->dropForeign('subjects_academic_year_id_foreign');
		});
		Schema::table('education_systems', function(Blueprint $table) {
			$table->dropForeign('education_systems_country_id_foreign');
		});
		Schema::table('teacher_subject', function(Blueprint $table) {
			$table->dropForeign('teacher_subject_teacher_id_foreign');
		});
		Schema::table('teacher_subject', function(Blueprint $table) {
			$table->dropForeign('teacher_subject_subject_id_foreign');
		});
		Schema::table('lessons_times', function(Blueprint $table) {
			$table->dropForeign('lessons_times_teacher_id_foreign');
		});
		Schema::table('lessons_times', function(Blueprint $table) {
			$table->dropForeign('lessons_times_lesson_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_teacher_id_foreign');
		});
		Schema::table('students', function(Blueprint $table) {
			$table->dropForeign('students_academic_year_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_student_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_teacher_id_foreign');
		});
		Schema::table('student_subject', function(Blueprint $table) {
			$table->dropForeign('student_subject_student_id_foreign');
		});
		Schema::table('student_subject', function(Blueprint $table) {
			$table->dropForeign('student_subject_subject_id_foreign');
		});
		Schema::table('student_lesson', function(Blueprint $table) {
			$table->dropForeign('student_lesson_student_id_foreign');
		});
		Schema::table('student_lesson', function(Blueprint $table) {
			$table->dropForeign('student_lesson_lesson_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_sub_category_id_foreign');
		});
		Schema::table('student_progress', function(Blueprint $table) {
			$table->dropForeign('student_progress_student_id_foreign');
		});
		Schema::table('student_progress', function(Blueprint $table) {
			$table->dropForeign('student_progress_teacher_id_foreign');
		});
		Schema::table('parents', function(Blueprint $table) {
			$table->dropForeign('parents_education_system_id_foreign');
		});
		Schema::table('student_parent', function(Blueprint $table) {
			$table->dropForeign('student_parent_student_id_foreign');
		});
		Schema::table('student_parent', function(Blueprint $table) {
			$table->dropForeign('student_parent_parent_id_foreign');
		});
		Schema::table('presence_absence', function(Blueprint $table) {
			$table->dropForeign('presence_absence_student_id_foreign');
		});
		Schema::table('presence_absence', function(Blueprint $table) {
			$table->dropForeign('presence_absence_teacher_id_foreign');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->dropForeign('blogs_blog_category_id_foreign');
		});
		Schema::table('views', function(Blueprint $table) {
			$table->dropForeign('views_post_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_post_id_foreign');
		});
		Schema::table('post_favourites', function(Blueprint $table) {
			$table->dropForeign('post_favourites_post_id_foreign');
		});
	}
}