<?php

namespace App\Models;

class Blog extends Eloquent {

	protected $table = 'blogs';
	public $timestamps = true;
	protected $fillable = array('name', 'description', 'blog_category_id');

	public function files()
	{
		return $this->morphMany('App\Models\File', 'fileable');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\BlogCategory', 'blog_category_id');
	}

}