<?php

namespace App\Models;

class Teacher extends Eloquent {

	protected $table = 'teachers';
	public $timestamps = true;
	protected $fillable = array('name', 'password', 'phone', 'address', 'profile_image', 'longitude', 'latitude', 'experince', 'qualification', 'cv', 'lesson_type');
	protected $hidden = array('password');

	public function Introductories()
	{
		return $this->morphMany('App\Models\File', 'fileable');
	}

	public function subjects()
	{
		return $this->belongsToMany('App\Models\Subject', 'teacher_subject');
	}

	public function lessons()
	{
		return $this->hasMany('App\Models\Lesson');
	}

	public function lessonTimes()
	{
		return $this->belongsToMany('App\Models\LessonTime')->withPivot(['date','day']);
	}

	public function ratings()
	{
		return $this->belongsToMany('App\Models\Teacher', 'ratings');
	}

	public function studetsProgress()
	{
		return $this->belongsToMany('App\Models\Student', 'student_progress')->withPivot(['rate','description']);
	}

	public function presenceAndAbsence()
	{
		return $this->belongsToMany('App\Models\PresenceAbsence', 'presence_absence')->withPivot(['type','date']);
	}

	public function posts()
	{
		return $this->hasMany('App\Models\Post', 'teacher_id');
	}

}