<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstitutionsTable extends Migration {

	public function up()
	{
		Schema::create('institutions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('abbr');
			$table->string('name');
			$table->string('full_name')->nullable();
			$table->integer('creator')->unsigned()->index();
			$table->integer('created_at')->unsigned();
			$table->integer('updated_at')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('institutions');
	}
}