<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfileToProfessionalGroupsTable extends Migration {

	public function up()
	{
		Schema::create('profile_to_professional_groups', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id')->unsigned()->index();
			$table->string('name');
			$table->integer('creator')->unsigned()->index();
			$table->integer('created_at')->unsigned();
			$table->integer('updated_at')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('profile_to_professional_groups');
	}
}