<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsultantProfilesTable extends Migration {

	public function up()
	{
		Schema::create('consultant_profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id')->unsigned();
			$table->integer('hcp_profile')->unsigned();
			$table->integer('primary_address_id')->unsigned();
			$table->smallInteger('number_of_publications');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('sees_patients');
			$table->string('practice_settings');
		});
	}

	public function down()
	{
		Schema::drop('consultant_profiles');
	}
}