<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePublicationTypesTable extends Migration {

	public function up()
	{
		Schema::create('publication_types', function(Blueprint $table) {
			$table->increments('id');
			$table->string('label');
			$table->string('description');
			$table->integer('creator')->unsigned()->index();
			$table->integer('created_at')->unsigned();
			$table->integer('updated_at')->unsigned();
			$table->integer('deleted_at')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('publication_types');
	}
}