<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEditorialBoardsTable extends Migration {

	public function up()
	{
		Schema::create('editorial_boards', function(Blueprint $table) {
			$table->increments('id');
			$table->string('year', 4)->index();
			$table->integer('address_id')->unsigned()->index();
			$table->integer('created_at')->unsigned();
			$table->integer('updated_at')->unsigned()->nullable();
			$table->integer('deleted_at')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('editorial_boards');
	}
}