<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfileToPublicationsTable extends Migration {

	public function up()
	{
		Schema::create('profile_to_publications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id')->unsigned();
			$table->integer('publication_id')->unsigned();
			$table->tinyInteger('weight')->unsigned();
			$table->integer('creator')->unsigned()->index();
			$table->integer('created_at')->unsigned();
			$table->integer('updated_at')->unsigned();
			$table->integer('deleted_at')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('profile_to_publications');
	}
}