<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('caddies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('caddies', function(Blueprint $table) {
			$table->foreign('platform')->references('id')->on('platforms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('caddies', function(Blueprint $table) {
			$table->foreign('dimension')->references('id')->on('Dimensions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('Dimensions', function(Blueprint $table) {
			$table->foreign('platform_id')->references('id')->on('platforms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('caddies', function(Blueprint $table) {
			$table->dropForeign('caddies_user_id_foreign');
		});
		Schema::table('caddies', function(Blueprint $table) {
			$table->dropForeign('caddies_platform_foreign');
		});
		Schema::table('caddies', function(Blueprint $table) {
			$table->dropForeign('caddies_dimension_foreign');
		});
		Schema::table('Dimensions', function(Blueprint $table) {
			$table->dropForeign('Dimensions_platform_id_foreign');
		});
	}
}