<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Caddies extends Eloquent {

	protected $table = 'caddies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function platform()
	{
		return $this->hasOne('Platforms');
	}

	public function dimension()
	{
		return $this->hasOne('Dimensions');
	}

}