<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LocataireBien extends Eloquent {

	protected $table = 'locatairesBiens';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_locataire', 'id_location', 'etat_contrat');
	protected $visible = array('slug', 'id_locataire', 'id_location', 'etat_contrat');

	public function locataire()
	{
		return $this->belongsTo('App\Locataire', 'id_locataire');
	}

	public function location()
	{
		return $this->belongsTo('App\Location', 'id_location');
	}

}