<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MoyenPaiement extends Eloquent {

	protected $table = 'moyensPaiements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'libelle');
	protected $visible = array('slug', 'libelle');

	public function location()
	{
		return $this->hasMany('App\Location', 'id_moyenPaiement');
	}

}