<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TypeAbonnement extends Eloquent {

	protected $table = 'typeAbonnements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'libelle', 'prix');
	protected $visible = array('slug', 'libelle', 'prix');

	public function abonnement()
	{
		return $this->hasMany('App\Abonnement', 'id_typeAbonnement');
	}

}