<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LicenseRealty extends Model 
{

    protected $table = 'license_realty';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('preset_id', 'realty_id');

    public function preset()
    {
        return $this->belongsTo('Presets', 'preset_id');
    }

    public function realty()
    {
        return $this->belongsTo('Realties', 'realty_id');
    }

}