<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('order_id');
			$table->double('total');
			$table->boolean('paid')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}