<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('pakage_id');
			$table->datetime('due_date');
			$table->datetime('upgrade_date');
			$table->datetime('expire_date');
			$table->integer('discount_id')->nullable();
			$table->integer('discount_count')->nullable();
			$table->double('total');
			$table->enum('status', array('active', 'inactive'));
			$table->integer('max_units');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}