<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->enum('type', array('monthly', 'yearly'));
			$table->integer('to_units')->nullable();
			$table->boolean('free')->default(0);
			$table->double('price');
			$table->string('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}