<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Activation extends Eloquent {

	protected $table = 'activations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('phone_num', 'code', 'user_id');

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}