<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Contractors extends Eloquent {

	protected $table = 'contractors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'national_id', 'birth_date', 'social_status', 'family_count', 'phone_num', 'email', 'work_location', 'nationality_id', 'country_id', 'user_id', 'family_number');

	public function country()
	{
		return $this->belongsTo('Countries', 'country_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

	public function contracts()
	{
		return $this->hasMany('Contracts', 'contractor_id');
	}

	public function nationality()
	{
		return $this->belongsTo('Countries', 'nationality_id');
	}

	public function socialstatus()
	{
		return $this->belongsTo('Presets', 'social_status');
	}

}