<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Contracts extends Eloquent {

	protected $table = 'contracts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'contractor_id', 'realty_id', 'unit_id', 'period', 'period_durations', 'value', 'value_durations', 'update', 'start_at', 'contract_status', 'expire_at', 'next_payments', 'days', 'notes');

	public function contractor()
	{
		return $this->belongsTo('Contractors', 'contractor_id');
	}

	public function realty()
	{
		return $this->belongsTo('Realties', 'realty_id');
	}

	public function unit()
	{
		return $this->belongsTo('Units', 'unit_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

	public function perioddurations()
	{
		return $this->belongsTo('Presets', 'period_durations');
	}

	public function valuedurations()
	{
		return $this->belongsTo('Presets', 'value_durations');
	}

	public function contractstatus()
	{
		return $this->belongsTo('Presets', 'contract_status');
	}

}