<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LicenseRealty extends Eloquent {

	protected $table = 'license_realty';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('preset_id', 'realty_id');

	public function preset()
	{
		return $this->belongsTo('Presets', 'preset_id');
	}

	public function realty()
	{
		return $this->belongsTo('Realties', 'realty_id');
	}

}