<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Packages extends Eloquent {

	protected $table = 'packages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'type', 'to_units', 'free', 'price', 'description');

	public function discounts()
	{
		return $this->hasMany('Discounts', 'package_id');
	}

}