<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Providers extends Eloquent {

	protected $table = 'providers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'service_id', 'email', 'reposible_name', 'phone_num', 'description', 'user_id');

	public function service()
	{
		return $this->belongsTo('Services', 'service_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}