<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'expire_date', 'max_units', 'order_id', 'visa');

	public function order()
	{
		return $this->belongsTo('Orders', 'order_id');
	}

}