<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgramsTable extends Migration {

	public function up()
	{
		Schema::create('Programs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('school_id')->unsigned();
			$table->integer('department_id')->unsigned();
			$table->tinyInteger('degree_type');
			$table->mediumInteger('avg_ta_stipend');
			$table->mediumInteger('avg_ra_stipend');
			$table->mediumInteger('avg_fellow_stipend');
			$table->text('stipend_notes');
			$table->text('requirements');
			$table->text('other_info');
			$table->string('field', 120);
		});
	}

	public function down()
	{
		Schema::drop('Programs');
	}
}