<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class CarTyps extends Model 
{

    protected $table = 'car_type';
    public $timestamps = true;
    protected $fillable = array('name', 'km_price', 'open_price');

    public function users()
    {
        return $this->hasMany('Models\User', 'car_type_id');
    }

    public function trips()
    {
        return $this->hasMany('Models\Trip', 'car_type_id');
    }

}