<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Reason extends Model 
{

    protected $table = 'reasons';
    public $timestamps = true;
    protected $fillable = array('name', 'type');

    public function rates()
    {
        return $this->hasMany('Models\Rate', 'reason_id');
    }

    public function compaints()
    {
        return $this->hasMany('Models\Complaint', 'reason_id');
    }

    public function trips()
    {
        return $this->hasMany('Models\Trip', 'cance_reason_id');
    }

}