<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('username', 'email', 'mobile', 'gender', 'birthday', 'type', 'password', 'confirm_code', 'status', 'wallet', 'notification', 'image', 'lat', 'lng', 'id_image_fornt', 'id_image_back', 'license_image_front', 'license_image_back', 'car_image_front', 'car_image_back', 'car_type_id', 'car_number', 'car_color', 'personal_license_front', 'personal_license_back', 'car_model_id', 'year_id');

    public function car_type()
    {
        return $this->belongsTo('Models\CarTyps', 'car_type_id');
    }

    public function users()
    {
        return $this->hasMany('Models\Token', 'user_id');
    }

    public function car_model()
    {
        return $this->belongsTo('Models\CarModel', 'car_model_id');
    }

    public function year()
    {
        return $this->belongsTo('Models\Year', 'year_id');
    }

    public function send_transfers()
    {
        return $this->belongsToMany('Models\User', 'transfers', 'user_id', 'receiver_id');
    }

    public function receive_transfers()
    {
        return $this->belongsToMany('Models\User', 'transfers', 'receiver_id', 'user_id');
    }

    public function user_trips()
    {
        return $this->hasMany('Models\Trip', 'user_id');
    }

    public function driver_trips()
    {
        return $this->hasMany('Models\Trip', 'driver_id');
    }

}