<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReasonsTable extends Migration {

	public function up()
	{
		Schema::create('reasons', function(Blueprint $table) {
			$table->increments('id');
			$table->json('name')->nullable();
			$table->enum('type', array('trip', 'rate', 'complaint'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reasons');
	}
}