<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransfersTable extends Migration {

	public function up()
	{
		Schema::create('transfers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('receiver_id')->unsigned()->nullable();
			$table->enum('type', array('user', 'driver'))->nullable();
			$table->string('amount', 191)->nullable();
			$table->string('code', 191)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transfers');
	}
}