<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripsTable extends Migration {

	public function up()
	{
		Schema::create('trips', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('driver_id')->unsigned()->nullable();
			$table->string('start_lat', 191)->nullable();
			$table->string('start_lng', 191)->nullable();
			$table->string('driver_lat', 191)->nullable();
			$table->string('driver_lng', 191)->nullable();
			$table->enum('online', array('true', 'false'))->nullable();
			$table->string('end_lat', 191)->nullable();
			$table->string('end_lng', 191)->nullable();
			$table->enum('time_type', array('now', 'later'))->nullable();
			$table->timestamp('time')->nullable();
			$table->integer('car_type_id')->unsigned()->nullable();
			$table->integer('payment_id')->unsigned();
			$table->string('trip_price', 191)->nullable();
			$table->enum('wallet_first', array('true', 'false'))->nullable();
			$table->integer('coupon_id')->unsigned()->nullable();
			$table->enum('status', array('waiting', 'in_progress', 'cancel', 'finish'))->nullable();
			$table->integer('cancel_reason_id')->unsigned()->nullable();
			$table->string('start_time', 191)->nullable();
			$table->string('end_time', 191)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('trips');
	}
}