<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rally extends Model 
{

    protected $table = 'rallies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function owners()
    {
        return $this->hasMany('User', 'owner_rally', 'rally_id', 'user_id');
    }

    public function followers()
    {
        return $this->hasMany('User', 'rally_user', 'rally_id', 'user_id');
    }

    public function parent()
    {
        return $this->belongsTo('Campaign');
    }

}