<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRalliesTable extends Migration {

	public function up()
	{
		Schema::create('rallies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->string('slug');
			$table->date('date');
			$table->time('time');
			$table->string('timezone');
			$table->string('city');
			$table->string('state');
			$table->string('street_address_1');
			$table->string('street_address_2');
			$table->smallInteger('zip_code');
			$table->bigInteger('longitude');
			$table->bigInteger('latitude');
			$table->text('description');
			$table->mediumInteger('goal');
			$table->string('video_youtube_id');
			$table->string('video_image');
			$table->integer('campaign_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('rallies');
	}
}