<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFieldsTable extends Migration {

	public function up()
	{
		Schema::create('fields', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('step_id')->unsigned();
			$table->string('name');
			$table->enum('type', array('text', 'number', 'date', 'checkbox'));
			$table->boolean('is_required');
			$table->string('validation_rules');
			$table->string('default_value');
			$table->string('options');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('fields');
	}
}