<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTriggersTable extends Migration {

	public function up()
	{
		Schema::create('triggers', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('workflow_id')->unsigned();
			$table->string('trigger_type');
			$table->string('trigger_details');
			$table->boolean('is_active');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('triggers');
	}
}