<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code')->unique();
			$table->integer('is_active')->default('0');
			$table->enum('status', array('fixed', 'percent'));
			$table->integer('value');
			$table->double('min_amount')->nullable();
			$table->string('max_amount')->nullable();
			$table->integer('usege_per_user_limit')->nullable();
			$table->integer('usage_limit')->nullable();
			$table->integer('free_shipping')->default('0');
			$table->date('expire_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}