<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_billingaddress', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_billingaddress', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_customer_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_order_id_foreign');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->dropForeign('payment_order_id_foreign');
		});
		Schema::table('payment', function(Blueprint $table) {
			$table->dropForeign('payment_customer_id_foreign');
		});
		Schema::table('customer_billingaddress', function(Blueprint $table) {
			$table->dropForeign('customer_billingaddress_customer_id_foreign');
		});
		Schema::table('customer_billingaddress', function(Blueprint $table) {
			$table->dropForeign('customer_billingaddress_country_id_foreign');
		});
	}
}