<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTable extends Migration {

	public function up()
	{
		Schema::create('payment', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->timestamps();
			$table->double('amount');
			$table->string('bankname')->nullable();
			$table->string('bic', 50)->nullable();
			$table->string('iban', 50);
			$table->string('account_holder', 50)->nullable();
			$table->string('bank_code', 50);
		});
	}

	public function down()
	{
		Schema::drop('payment');
	}
}