<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSemesterTable extends Migration {

	public function up()
	{
		Schema::create('semester', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('student_id')->unsigned();
			$table->integer('section_id')->unsigned();
			$table->string('academic_year');
			$table->integer('semester');
			$table->float('total');
			$table->float('average');
			$table->integer('rank')->unsigned();
			$table->string('conduct');
			$table->integer('absence')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('semester');
	}
}