<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('teachers', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employee')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('section', function(Blueprint $table) {
			$table->foreign('grade_id')->references('id')->on('grade')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assesment', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teachers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assesment', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subject')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assesment', function(Blueprint $table) {
			$table->foreign('assesment_type_id')->references('id')->on('assesment_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('assesment', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('section')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('student_assesment', function(Blueprint $table) {
			$table->foreign('assesment_id')->references('id')->on('assesment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('student_assesment', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('semester', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('semester', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('section')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('teachers', function(Blueprint $table) {
			$table->dropForeign('teachers_employee_id_foreign');
		});
		Schema::table('section', function(Blueprint $table) {
			$table->dropForeign('section_grade_id_foreign');
		});
		Schema::table('assesment', function(Blueprint $table) {
			$table->dropForeign('assesment_teacher_id_foreign');
		});
		Schema::table('assesment', function(Blueprint $table) {
			$table->dropForeign('assesment_subject_id_foreign');
		});
		Schema::table('assesment', function(Blueprint $table) {
			$table->dropForeign('assesment_assesment_type_id_foreign');
		});
		Schema::table('assesment', function(Blueprint $table) {
			$table->dropForeign('assesment_section_id_foreign');
		});
		Schema::table('student_assesment', function(Blueprint $table) {
			$table->dropForeign('student_assesment_assesment_id_foreign');
		});
		Schema::table('student_assesment', function(Blueprint $table) {
			$table->dropForeign('student_assesment_student_id_foreign');
		});
		Schema::table('semester', function(Blueprint $table) {
			$table->dropForeign('semester_student_id_foreign');
		});
		Schema::table('semester', function(Blueprint $table) {
			$table->dropForeign('semester_section_id_foreign');
		});
	}
}