<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Grade extends Eloquent {

	protected $table = 'grade';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function getSection()
	{
		return $this->hasMany('App\Model\Section');
	}

	public function getSubject()
	{
		return $this->belongsToMany('App\Model\Subject');
	}

}