<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchoolTable extends Migration {

	public function up()
	{
		Schema::create('school', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->string('moto', 255);
			$table->string('logo', 255);
			$table->text('mission');
			$table->text('vision');
			$table->text('address');
			$table->text('location')->nullable();
			$table->text('background')->nullable();
			$table->string('owner');
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('school');
	}
}