<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductDiscountTable extends Migration {

	public function up()
	{
		Schema::create('product_discount', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('product_id')->unsigned();
			$table->bigInteger('customer_group_id');
			$table->smallInteger('quantity')->default('0');
			$table->smallInteger('priority')->default('1');
			$table->decimal('price', 15,4)->default('0.0000');
			$table->date('date_start');
			$table->date('date_end');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_discount');
	}
}