<?php

namespace product_discount;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product_discount extends Model 
{

    protected $table = 'product_discount';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'customer_group_id', 'quantity', 'priority', 'price', 'date_start', 'date_end');

    public function product()
    {
        return $this->belongsTo('Product');
    }

}