<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArtworkTable extends Migration {

	public function up()
	{
		Schema::create('artwork', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('category_id')->unsigned()->nullable()->default('0');
			$table->string('slug')->unique();
			$table->integer('price_range_id')->unsigned()->nullable()->default('0');
			$table->decimal('price', 9,3)->nullable()->default('NULL');
			$table->integer('vat')->nullable()->default('NULL');
			$table->decimal('full_price', 9,3)->nullable()->default('NULL');
			$table->tinyInteger('is_discounted')->nullable()->default('NULL');
			$table->tinyInteger('discounted_by')->nullable()->default('NULL');
			$table->integer('discount_percent')->nullable()->default('0');
			$table->integer('views');
			$table->integer('favorites');
			$table->tinyInteger('is_active');
			$table->tinyInteger('for_sale');
			$table->integer('size_range_id')->unsigned()->nullable()->index()->default('0');
			$table->integer('orientation')->nullable()->default('NULL');
			$table->double('depth')->nullable()->default('NULL');
			$table->double('width')->nullable()->default('NULL');
			$table->double('height')->nullable()->default('NULL');
			$table->double('weight')->nullable()->default('NULL');
			$table->integer('created_year')->nullable();
			$table->tinyInteger('copyright_owner')->nullable()->default('NULL');
			$table->tinyInteger('is_hidden');
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
			$table->timestamp('published_at');
			$table->string('translation_description_code')->nullable()->default('0');
			$table->string('translation_title_code')->nullable()->default('0');
			$table->tinyInteger('shipping')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('artwork');
	}
}