<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Artwork extends Model 
{

    protected $table = 'artwork';
    public $timestamps = false;

    public function user()
    {
        return $this->belongsToMany('App\User');
    }

    public function accountfavorites()
    {
        return $this->belongsToMany('App\User')->using('App\Favorites');
    }

    public function caregory()
    {
        return $this->belongsTo('App\Category');
    }

    public function theme()
    {
        return $this->belongsToMany('App\Theme');
    }

    public function image()
    {
        return $this->belongsToMany('App\User')->withPivot('is_primary');
    }

    public function keyword()
    {
        return $this->belongsToMany('App\Keyword');
    }

    public function price_range()
    {
        return $this->belongsTo('App\User');
    }

    public function sold_artwork()
    {
        return $this->morphOne('App\Sold_artwork');
    }

    public function translation_title_code()
    {
        return $this->belongsTo('App\Translation', 'code', 'translation_title_code');
    }

    public function translation_description_code()
    {
        return $this->belongsTo('App\Translation', 'code', 'translation_description_code');
    }

}