<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfileTable extends Migration {

	public function up()
	{
		Schema::create('profile', function(Blueprint $table) {
			$table->increments('user_id');
			$table->integer('language');
			$table->string('slug')->unique();
			$table->integer('image_id')->unsigned();
			$table->string('firstname');
			$table->string('lastname');
			$table->string('email');
			$table->date('dob');
			$table->string('phone');
			$table->string('address');
			$table->string('city');
			$table->string('zip');
			$table->string('country', 45)->nullable()->default('NULL');
			$table->string('IBAN');
			$table->string('SWIFT');
			$table->string('about_user_langcode');
			$table->integer('is_associated');
			$table->string('association');
			$table->tinyInteger('kuvataiteilijamatrikkeli');
			$table->string('is_mailsubscribed');
			$table->string('profile_completed');
			$table->double('commission')->default('30.00');
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('profile');
	}
}