<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingProfileTable extends Migration {

	public function up()
	{
		Schema::create('shipping_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->string('country');
			$table->string('firstname');
			$table->string('lastname');
			$table->string('company')->nullable()->default('NULL');
			$table->string('address');
			$table->string('address_additional')->nullable()->default('NULL');
			$table->string('city');
			$table->string('email');
			$table->string('phone');
			$table->string('zip');
			$table->string('order_notes')->nullable();
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_profile');
	}
}