<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSoldArtworkTable extends Migration {

	public function up()
	{
		Schema::create('sold_artwork', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('payment_id')->unsigned();
			$table->integer('artwork_id')->unsigned();
			$table->string('delivery_status')->nullable()->default('NULL');
			$table->string('pick_up_address')->nullable()->default('NULL');
			$table->string('pick_up_city')->nullable()->default('NULL');
			$table->string('pick_up_zip')->nullable()->default('NULL');
			$table->string('tracking_id')->nullable()->default('NULL');
			$table->string('pdf_id')->nullable()->default('NULL');
			$table->date('pick_up_date')->nullable();
			$table->date('delivery_date')->nullable();
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('sold_artwork');
	}
}